package lab;

/**
 * Aufgabe H1b)
 * 
 * Abgabe von: <name>, <name> und <name>
 */

import frame.TreeNode;
import frame.Process;

public class CompletelyFairScheduler {
	
	private RedBlackTree tree;
	private int windowMaxLength;
	
	/**
	 * Creating a new CompletelyFairScheduler
	 * @param windowMaxLength is the maximal length of one execution window
	 */
	public CompletelyFairScheduler(int windowMaxLength) {
		tree = new RedBlackTree();
		this.windowMaxLength = windowMaxLength;
	}
	
	/**
	 * Distribute execution windows to the processes.
	 * @param windows The number of execution windows to distribute
	 */
	public void run(int windows) {
		// TODO: Implement
		for (int i = 0; i < windows; i++) {
			// Root is empty, abort run
			if (tree.root() == tree.nil()) {
				break;
			}
			
			// Get node with smallest key
			TreeNode nodeWithSmallestKey = tree.minimum();
			// Get process from node
			Process processWithSmallestKey = nodeWithSmallestKey.value;
			
			// Run process with maximal window length
			processWithSmallestKey.run(windowMaxLength);
			// Remove Process from Tree
			tree.delete(nodeWithSmallestKey);
			
			// Check if process has finished
			if (!processWithSmallestKey.finished()) {
				// Not finished
				// Add process to tree
				this.add(processWithSmallestKey);
			}
		}
	}
	
	/**
	 * Add a process to the Scheduler.
	 */
	public void add(Process process) {
		// TODO: Implement

		// Set process key to variable
		int processKey = process.executionTime();

		// Check if in tree a node exists with same key
		while (tree.search(processKey) != tree.nil()) {
			// We found a node
			// Set key higher
			processKey++;
		}

		// Ready!
		// Node not found, create new Node with new key
		TreeNode nodeWithNewKey = new TreeNode();
		nodeWithNewKey.key = processKey; // Set new key
		nodeWithNewKey.value = process; // Set process
		
		// Insert to tree
		tree.insert(nodeWithNewKey);
	}
	
	// DO NOT MODIFY
	// used for the tests
	public RedBlackTree getTree() {
		return tree;
	}

}
