package lab;

/**
 * Aufgabe H1a)
 * 
 * Abgabe von: <name>, <name> und <name>
 */


import frame.TreeNode;

/**
 * An implementation of a Black-Red-Tree
 */
public class RedBlackTree {
	
	private TreeNode _root;
	private TreeNode _nil;
	
	public RedBlackTree() {
		_nil = new TreeNode();
		_root = _nil;
	}
	
	public TreeNode root() {
		return this._root;
	}
	
	public TreeNode nil() {
		return this._nil;
	}
	
	/**
	 * Return the node with the given key, or nil, if no such node exists.
	 */
	public TreeNode search(int key) {
        // TODO: Implement

		// Initialize a pointer to the root to traverse the tree
		TreeNode current = _root;

		// While we haven't reached the end of the tree
		while (current != nil()){
			// If we have found a node with a key equal to key
			if (current.key == key) {
				// return that node and exit search(int)
				return current;
			}

			// go left or right based on value of current and key
			else if (current.key < key) {
				current = current.right;
			}

			// go left or right based on value of current and key
			else {
				current = current.left;
			}
		}

		// we have not found a node whose key is "key"
		return nil();
	}
	
	/**
	 * Return the node with the smallest key
	 */
	public TreeNode minimum() {
		return minimumSubtree(_root);
	}
	
	/**
	 * Return the node with the smallest key in the subtree that has x as root node.
	 */
	public TreeNode minimumSubtree(TreeNode x) {
		// TODO: Implement

		// while there is a smaller key, keep going left
		while (x.left != nil()) {
			x = x.left;
		}
		
		return x;
	}
	
	/**
	 * Return the node with the greatest key.
	 */
	public TreeNode maximum() {
		return maximumSubtree(_root);
	}
	
	/**
	 * Return the node with the greatest key in the subtree that has x as root node.
	 */
	public TreeNode maximumSubtree(TreeNode x) {
		// TODO: Implement
		// if x.left is not nil, call treeMinimum(x.right) and
		// return it's value
		if (x.left != nil()) {
			return minimumSubtree(x.right);
		}

		TreeNode y = x.p;

		// while x is it's parent's right child...
		while (y != nil() && x == y.right) {
			// Keep moving up in the tree
			x = y;
			y = y.p;
		}
		// Return successor
		return y;
	}

	/**
	 * Insert newNode into the tree.
	 */
	public void insert(TreeNode newNode) {
		// TODO: Implement
		// z is the comments is newNode
		
		// Create a reference to root & initialize a node to nil
		TreeNode y = nil();
		TreeNode x = root();

		// While we haven't reached a the end of the tree keep
		// trying to figure out where z should go
		while (x != nil()) {
			y = x;

			// if z.key is < than the current key, go left
			if (newNode.key < x.key) {
				x = x.left;
			}

			// else z.key >= x.key so go right.
			else {
				x = x.right;
			}
		}
		// y will hold z's parent
		newNode.p = y;

		// Depending on the value of y.key, put z as the left or
		// right child of y
		if (y == nil()) {
			this._root = newNode;
		}
		else if (newNode.key < y.key) {
			y.left = newNode;
		}
		else {
			y.right = newNode;
		}

		// Initialize z's children to nil and z's color to red
		newNode.left = nil();
		newNode.right = nil();
		newNode.color = TreeNode.NodeColor.RED;

		// Call insertFixup(z)
		insertFixup(newNode);
	}
	
	private void insertFixup(TreeNode newNode) {
		// z in the comments is newNode
		
		TreeNode y = nil();
		// While there is a violation of the RedBlackTree properties..
		while (newNode.p.color == TreeNode.NodeColor.RED) {
			// If z's parent is the the left child of it's parent.
			if (newNode.p == newNode.p.p.left) {
				// Initialize y to z 's cousin
				y = newNode.p.p.right;

				// Case 1: if y is red...recolor
				if (y.color == TreeNode.NodeColor.RED) {
					newNode.p.color = TreeNode.NodeColor.BLACK;
					y.color = TreeNode.NodeColor.BLACK;
					newNode.p.p.color = TreeNode.NodeColor.RED;
					newNode = newNode.p.p;
				}
				// Case 2: if y is black & z is a right child
				else if (newNode == newNode.p.right) {

					// leftRotaet around z's parent
					newNode = newNode.p;
					leftRotate(newNode);
				}

				// Case 3: else y is black & z is a left child
				else {
					// recolor and rotate round z's grandpa
					newNode.p.color = TreeNode.NodeColor.BLACK;
					newNode.p.p.color = TreeNode.NodeColor.RED;
					rightRotate(newNode.p.p);
				}
			}

			// If z's parent is the right child of it's parent.
			else {
				// Initialize y to z's cousin
				y = newNode.p.p.left;

				// Case 1: if y is red...recolor
				if (y.color == TreeNode.NodeColor.RED) {
					newNode.p.color = TreeNode.NodeColor.BLACK;
					y.color = TreeNode.NodeColor.BLACK;
					newNode.p.p.color = TreeNode.NodeColor.RED;
					newNode = newNode.p.p;
				}

				// Case 2: if y is black and z is a left child
				else if (newNode == newNode.p.left) {
					// rightRotate around z's parent
					newNode = newNode.p;
					rightRotate(newNode);
				}
				// Case 3: if y  is black and z is a right child
				else {
					// recolor and rotate around z's grandpa
					newNode.p.color = TreeNode.NodeColor.BLACK;
					newNode.p.p.color = TreeNode.NodeColor.RED;
					leftRotate(newNode.p.p);
				}
			}
		}
		// Color root black at all times
		_root.color = TreeNode.NodeColor.BLACK;
	}
	
	/**
	 * Delete node toDelete from the tree.
	 */
	public void delete(TreeNode toDelete) {
		// v in the comments is toDelete
		
		// TODO: Implement
		//raise new RuntimeException("Not implemented yet!");
		TreeNode z = search(toDelete.key);

		// Declare variables
		TreeNode x = nil();
		TreeNode y = nil();

		// if either one of z's children is nil, then we must remove z
		if (z.left == nil() || z.right == nil()) {
			y = z;
		}

		// else we must remove the successor of z
		else {
			y = maximumSubtree(z);
		}

		// Let x be the left or right child of y (y can only have one child)
		if (y.left != nil()) {
			x = y.left;
		}
		else {
			x = y.right;
		}

		// link x's parent to y's parent
		x.p = y.p;

		// If y's parent is nil, then x is the root
		if (y.p == nil()) {
			_root = x;
		}

		// else if y is a left child, set x to be y's left sibling
		else if (y.p.left != nil() && y.p.left == y) {
			y.p.left = x;
		}

		// else if y is a right child, set x to be y's right sibling
		else if (y.p.right != nil() && y.p.right == y) {
			y.p.right = x;
		}

		// if y != z, transfer y's satellite data into z.
		if (y != z) {
			z.key = y.key;
		}

		// If y's color is black, it is a violation of the
		// RedBlackTree properties so call removeFixup()
		if (y.color == TreeNode.NodeColor.BLACK) {
			removeFixup(x);
		}
	}
	
	// @param: x, the child of the deleted node from remove(RedBlackNode v)
	// Restores the Red Black properties that may have been violated during
	// the removal of a node in remove(RedBlackNode v)
	private void removeFixup(TreeNode node){
		// x in the comments is node
		
		TreeNode w;

		// While we haven't fixed the tree completely...
		while (node != _root && node.color == TreeNode.NodeColor.BLACK){
			// if x is it's p's left child
			if (node == node.p.left) {
				// set w = x's sibling
				w = node.p.right;

				// Case 1, w's color is red.
				if (w.color == TreeNode.NodeColor.RED){
					w.color = TreeNode.NodeColor.BLACK;
					node.p.color = TreeNode.NodeColor.RED;
					leftRotate(node.p);
					w = node.p.right;
				}

				// Case 2, both of w's children are black
				if (w.left.color == TreeNode.NodeColor.BLACK &&
							w.right.color == TreeNode.NodeColor.BLACK) {
					w.color = TreeNode.NodeColor.RED;
					node = node.p;
				}
				// Case 3 / Case 4
				else{
					// Case 3, w's right child is black
					if (w.right.color == TreeNode.NodeColor.BLACK) {
						w.left.color = TreeNode.NodeColor.BLACK;
						w.color = TreeNode.NodeColor.RED;
						rightRotate(w);
						w = node.p.right;
					}
					// Case 4, w = black, w.right = red
					w.color = node.p.color;
					node.p.color = TreeNode.NodeColor.BLACK;
					w.right.color = TreeNode.NodeColor.BLACK;
					leftRotate(node.p);
					node = _root;
				}
			}
			// if x is it's p's right child
			else {
				// set w to x's sibling
				w = node.p.left;

				// Case 1, w's color is red
				if (w.color == TreeNode.NodeColor.RED){
					w.color = TreeNode.NodeColor.BLACK;
					node.p.color = TreeNode.NodeColor.RED;
					rightRotate(node.p);
					w = node.p.left;
				}

				// Case 2, both of w's children are black
				if (w.right.color == TreeNode.NodeColor.BLACK &&
							w.left.color == TreeNode.NodeColor.BLACK){
					w.color = TreeNode.NodeColor.RED;
					node = node.p;
				}

				// Case 3 / Case 4
				else {
					// Case 3, w's left child is black
					 if (w.left.color == TreeNode.NodeColor.BLACK) {
						w.right.color = TreeNode.NodeColor.BLACK;
						w.color = TreeNode.NodeColor.RED;
						leftRotate(w);
						w = node.p.left;
					}

					// Case 4, w = black, and w.left = red
					w.color = node.p.color;
					node.p.color = TreeNode.NodeColor.BLACK;
					w.left.color = TreeNode.NodeColor.BLACK;
					rightRotate(node.p);
					node = _root;
				}
			}
		}// end while

		// set x to black to ensure there is no violation of
		// RedBlack tree Properties
		node.color = TreeNode.NodeColor.BLACK;
	}
	
	// @param: x, The node which the lefRotate is to be performed on.
	// Performs a leftRotate around x.
	private void leftRotate(TreeNode x){
		// Perform the left rotate as described in the algorithm
		// in the course text.
		TreeNode y;
		y = x.right;
		x.right = y.left;

		// Check for existence of y.left and make pointer changes
		if (y.left != nil()) {
			y.left.p = x;
		}
		y.p = x.p;

		// x's parent is nil
		if (x.p == nil()) {
			_root = y;
		}

		// x is the left child of it's parent
		else if (x.p.left == x) {
			x.p.left = y;
		}

		// x is the right child of it's parent.
		else {
			x.p.right = y;
		}

		// Finish of the leftRotate
		y.left = x;
		x.p = y;
	}
	
	// @param: x, The node which the rightRotate is to be performed on.
	// Updates the numLeft and numRight values affected by the Rotate.
	private void rightRotate(TreeNode y) {
        // Perform the rotate as described in the course text.
		TreeNode x = y.left;
        y.left = x.right;

        // Check for existence of x.right
        if (x.right != nil()) {
            x.right.p = y;
        }
        x.p = y.p;

        // y.parent is nil
        if (y.p == nil()) {
            _root = x;
        }

        // y is a right child of it's parent.
        else if (y.p.right == y) {
            y.p.right = x;
        }

        // y is a left child of it's parent.
        else {
            y.p.left = x;
        }
        x.right = y;

        y.p = x;
	}

}
