/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.internal.InternalModuleInfo;
import org.eclipse.m2e.jdt.internal.InternalModuleSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleSupport {
    public static final String MODULE_INFO_JAVA = "module-info.java";
    static final boolean IS_MODULE_SUPPORT_AVAILABLE;
    static final boolean IS_PATCH_MODULE_SUPPORT_AVAILABLE;
    private static final Logger log;

    static {
        log = LoggerFactory.getLogger(ModuleSupport.class);
        boolean isModuleSupportAvailable = false;
        boolean isPatchModuleSupportAvailable = false;
        try {
            Class.forName("org.eclipse.jdt.core.IModuleDescription");
            isModuleSupportAvailable = true;
            try {
                IRuntimeClasspathEntry.class.getDeclaredField("PATCH_MODULE");
                isPatchModuleSupportAvailable = true;
            }
            catch (NoSuchFieldException | SecurityException exception) {}
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        IS_MODULE_SUPPORT_AVAILABLE = isModuleSupportAvailable;
        IS_PATCH_MODULE_SUPPORT_AVAILABLE = isPatchModuleSupportAvailable;
    }

    public static void configureClasspath(IMavenProjectFacade facade, IClasspathDescriptor classpath, IProgressMonitor monitor) throws CoreException {
        if (!IS_MODULE_SUPPORT_AVAILABLE || classpath == null) {
            return;
        }
        InternalModuleSupport.configureClasspath(facade, classpath, monitor);
    }

    public static int determineModularClasspathProperty(IClasspathEntry entry) {
        if (!IS_PATCH_MODULE_SUPPORT_AVAILABLE) {
            return 3;
        }
        return InternalModuleSupport.determineModularClasspathProperty(entry);
    }

    public static IRuntimeClasspathEntry createRuntimeClasspathEntry(IFolder folder, int classpathProperty, IProject project) {
        if (!IS_PATCH_MODULE_SUPPORT_AVAILABLE) {
            return JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)folder.getFullPath());
        }
        return InternalModuleSupport.createRuntimeClasspathEntry(folder, classpathProperty, project);
    }

    public static int determineClasspathPropertyForMainProject(boolean isModularConfiguration, IJavaProject javaProject) {
        if (!IS_PATCH_MODULE_SUPPORT_AVAILABLE) {
            return 3;
        }
        return InternalModuleSupport.determineClasspathPropertyForMainProject(isModularConfiguration, javaProject);
    }

    public static boolean isModularConfiguration(ILaunchConfiguration configuration) {
        if (!IS_PATCH_MODULE_SUPPORT_AVAILABLE) {
            return false;
        }
        return InternalModuleSupport.isModularConfiguration(configuration);
    }

    public static IRuntimeClasspathEntry newModularProjectRuntimeClasspathEntry(IJavaProject javaProject) {
        if (!IS_PATCH_MODULE_SUPPORT_AVAILABLE) {
            return JavaRuntime.newProjectRuntimeClasspathEntry((IJavaProject)javaProject);
        }
        return InternalModuleSupport.newModularProjectRuntimeClasspathEntry(javaProject);
    }

    public static boolean isMavenJavaProject(IProject project) {
        try {
            return project != null && project.isOpen() && project.hasNature("org.eclipse.m2e.core.maven2Nature") && project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    static InternalModuleInfo getModuleInfo(IJavaProject jp, IProgressMonitor monitor) throws JavaModelException {
        return InternalModuleSupport.getModuleInfo(jp, monitor);
    }
}

